﻿$(function () {

    var scrollButtonOptions = {
        autoLinkPos: "toTop-right",
        autoLinkClass: "btn-scroll-to-top btn btn-large btn-primary",
        autoLinkIcon: "schema-glyph schema-glyph-chevron-thin-up",
        autoLinkText: "",
        min: 200,
        inDelay: 200,
        outDelay: 200,
        scrollSpeed: 50
    };

    var scrollButton = $('<span id="' + scrollButtonOptions.autoLinkPos + '" class="' + scrollButtonOptions.autoLinkClass + '"><i class="' + scrollButtonOptions.autoLinkIcon + '"></i> ' + scrollButtonOptions.autoLinkText + "</span>");
    $("body").append(scrollButton);
    
    $('.content-container').scroll(function () {
        var a = $(this).scrollTop();
        var b = scrollButtonOptions.min;
        if ($(this).scrollTop() > scrollButtonOptions.min) {
            scrollButton.fadeIn(scrollButtonOptions.inDelay)
        } else {
            scrollButton.fadeOut(scrollButtonOptions.outDelay)
        }
    });

    scrollButton.hide().click(function () {
        $('.content-container').animate({
            scrollTop: 0
        }, scrollButtonOptions.scrollSpeed);
        return false;
    });
});